import numpy as np
import argparse


def append_concorde_args(parser):
    parser.add_argument('--eda-lambdas', type=str, default=None, help='this value should be latency, energy, balanced (they are strings), or {latency_lambda,energy_lambda,area_lambda} (they are real value)')
    parser.add_argument('--scale-value',type=float, default=1.)
    parser.add_argument('--p', type=float, default=1.01)
    parser.add_argument('--generator-lr', type=float, default=0.01)
    parser.add_argument('--latency-constrained-value', type=str, default='inf')
    parser.add_argument('--energy-constrained-value', type=str, default='inf')
    parser.add_argument('--area-constrained-value', type=str, default='inf')
    parser.add_argument('--delta-generator', type=float, default=0.0001)
    parser.add_argument('--delta-supernet', type=float, default=0.0001)
    parser.add_argument('-gbs', '--generator-batch-size', type=int, default=64)
    parser.add_argument('--warmup-train-generator', action='store_true')
    parser.add_argument('--num-ops', type=int, default=7)
    parser.add_argument('--arch-tau', type=float, default=5)
    parser.add_argument('--except-const', action='store_true', help='except constrained targets from hw_loss')
    parser.add_argument('--swish', action='store_true', help='use swish instead of ReLU while train arch param & generator')
    parser.add_argument('--flexible-scaler', action='store_true', help='change scale value according to constraints compliance')
    parser.add_argument('--estimator-path', type=str, required=True)
    parser.add_argument('--soft-constraint', action='store_true', help='give soft constraint to both generator & architecture parameter')
    parser.add_argument('--linear-penalty', type=float, default=1.)

