#!/bin/bash


echo dataset $1 path $2 lambda $3 scaler $4 constrained metric $5 target_value $6 slope $7

if [ $1 == 'imagenet' ] ; then
    width_stages='24,40,80,96,192,320'
    n_cell_stages='4,4,4,4,4,1'
    stride_stages='2,2,2,1,2,1'
    estimator_path='proxylessnas/search/estimator_weights/estimator_imagenet.pt'
elif [ $1 == 'cifar10' ] ; then
    width_stages='32,64,128'
    n_cell_stages='6,6,6'
    stride_stages='1,2,2'
    estimator_path='proxylessnas/search/estimator_weights/estimator_cifar10.pt'
elif [ $1 == 'cifar100' ] ; then
    width_stages='32,64,128'
    n_cell_stages='6,6,6'
    stride_stages='1,2,2'
    estimator_path='proxylessnas/search/estimator_weights/estimator_cifar100.pt'
fi

python3 proxylessnas/search/co_design.py --dataset $1 --width_stages $width_stages --n_cell_stages $n_cell_stages --stride_stages $stride_stages --warmup-train-generator --path proxylessnas/search/outputs/${2} --eda-lambdas $3 --scale-value $4 --estimator-path $estimator_path --${5}-constrained-value $6 --soft-constraint --slope $7

