from RHOSolver import RHOSolver
from uniform_instance_gen import uni_instance_gen
from network.JobShopSetTransformer import JobShopSetTransformer
from CPSolver import CPSolver
from params import *
import numpy as np
from TRHOSolver import TRHOSolver
import torch
import os
import time
os.environ["KMP_DUPLICATE_LIB_OK"] = "TRUE"

if __name__ == '__main__':
    num_instances = 10  # 生成10个随机实例
    all_net_results = []
    all_greedy_results = []
    model =  JobShopSetTransformer(m=10)
    model.load_state_dict(torch.load('model/jsst1000_10_10_100_AU0.pth'))
    solver = RHOSolver(numofMachines=10, k=10,net=model)
    tsolver = TRHOSolver(numofMachines=10)
    cpSolver = CPSolver()
    Utilization = []
    for i in range(num_instances):
        print(f"\n开始测试实例 {i+1}/{num_instances}...")
        N = configs.test_chooseNet_N
        M = 10
        BWS = False
        # 生成N个工件M个机器的随机实例,加工时间在1-99之间
        np.random.seed(i)
        times, machines = uni_instance_gen(N, M, 1, 100)
        data = (times, machines)
        try:
            # 测试神经网络模型
            
            solver.reset(data)
            solver.GuidedRandomGreedyChoose(data = data,k=M)
            schedule1 = cpSolver.solve_blocking_job_shop([data[0][solver.curSelect],data[1][solver.curSelect]],
                                                        None,bws = False,time_limit=40)
            u1 = schedule1.cal_utilization()
            print(u1)
            solver.reset(data)
            solver.CPGreedyChoose(data = data,k=M,time_limit=40)
            schedule2 = cpSolver.solve_blocking_job_shop([data[0][solver.curSelect],data[1][solver.curSelect]],
                                                        None,bws = False,time_limit=40)
            u2 = schedule2.cal_utilization()
            print(u2)
            Utilization.append(u1/u2)
            solver.reset(data)
            solver.randomChoose(k=M)
            schedule3 = cpSolver.solve_blocking_job_shop([data[0][solver.curSelect],data[1][solver.curSelect]],
                                                        None,bws = False,time_limit=40)
            u3 = schedule3.cal_utilization()
            print("net选择效率 : " ,100 * u1/u2)
            print("随机选择效率 : " ,100 * u3/u2)
            
            

           
            
        except Exception as e:
            print(f"  实例 {i+1} 测试出错: {str(e)}")
            continue
    print( "net选择效率平均值 : " ,np.mean(Utilization))

