# Symmetry-Driven Discovery of Dynamical Variables in Molecular Simulations

This repository contains the code to reproduce the results from the paper, "Symmetry-Driven Discovery of Dynamical Variables in Molecular Simulations".

## Table of Contents
1. [Setup Instructions](#setup-instructions)
2. [Commands and Tasks](#commands-and-tasks)
    - [Finding the DOFs](#finding-the-dofs)
    - [Simulating System Around the Trajectories](#simulating-system-around-the-trajectories)
    - [Plotting the Trajectories and the Conformers](#plotting-the-trajectories-and-the-conformers)
---

## Setup Instructions

To set up the project environment, ensure you have **conda** installed on your system. Follow these steps:

### 1. Create and Activate the Environment
Use the provided env.yml file to set up the environment:
```bash
conda env create --name your-envname --file=env.yml
conda activate your-envname
```

### 2. Run Long Simulations Baselines
If long simulation baselines (.dcd files) are not found under the molecule_files folder, run the following commands to setup the baseline with and without solvent:
```bash
python long_simulation_baseline.py
python long_simulation_baseline.py --solvent
```

### 3. Plot the Energy Landscape 
Plot the enery landscape explored by the simulations.
```bash
python free_energy.py
python free_energy.py --solvent
```

## Commands and Tasks
### Finding the DOFs
To find the DOF trajectories using all the methods mentioned in the paper, run:
```bash
python finding_DOFs.py
```


### Simulating System Around the Trajectories
To explore the energy landscape and discover Conformers in the vacuum and in water, run the commands
```bash
python energy_landscape.py
python energy_landscape.py --solvent
```

### Plotting the Trajectories and the Conformers
To plot the trajectory of starting points and the conformations sampled by each method run 
```bash
python plot_contours.py
python plot_contours.py --solvent
```
To get the structures of the conformers discovered, run
```bash
python pdb_to_png.py
python pdb_to_png.py --solvent
```