from openmm.app import * # DCDReporter, StateDataReporter, PDBFile, ForceField, Simulation
from openmm import *
from openmm.unit import *
from sys import stdout
import argparse

parser = argparse.ArgumentParser(description="My parser")
parser.add_argument('--solvent', action='store_true')
parser.add_argument('--no-solvent', dest='solvent', action='store_false')
parser.set_defaults(solvent=False)

args = parser.parse_args()

solvent = args.solvent

pdb = PDBFile("molecule_files/alanine-dipeptide.pdb")
if solvent:
        forcefield = ForceField("amber99sbnmr.xml", "amber99_obc.xml")
        filename = 'molecule_files/alanine-dipeptide_water_traj_500ns.dcd'
else:
        forcefield = ForceField("amber99sbnmr.xml")
        filename = 'molecule_files/alanine-dipeptide_traj_500ns.dcd'

system = forcefield.createSystem(pdb.topology, nonbondedCutoff=3 * nanometer, constraints=HBonds)
integrator = LangevinIntegrator(300 * kelvin, 1 / picosecond, 2 * femtoseconds)
simulation = Simulation(pdb.topology, system, integrator)
pos = pdb.getPositions(asNumpy=True)
print(pos)
simulation.context.setPositions(pos)
simulation.minimizeEnergy()
simulation.reporters.append(DCDReporter(filename, 250))
simulation.reporters.append(StateDataReporter(stdout, 250000, step=True,
        potentialEnergy=True, temperature=True))
simulation.step(250000000)