# Anonlibrary

Anonlibrary is a framework to inspect the inner workings of neural networks.

The framework aims to provide a set of tools to estimate the semantic alignment between human-comprehensible concepts and neural units.
While most training techniques are generally and correctly considered to produce distributed representations, empirical analysis has shown that at least some network sections might be easily interpreted assuming localist representations. 
Anonlibrary enables such analyses for networks in the visual domain by following and extending the network dissection paradigm, which estimates the semantic-alignment by monitoring the activations of a unit in respect of a pixel-annotated dataset.

This repository is forked off [NetDissect-Lite](https://github.com/CSAILVision/NetDissect-Lite) and introduces the following improvements:

- Support for the analysis of fully connected units.
- Support to load annotated datasets other than [Broden](https://github.com/CSAILVision/NetDissect#download).
- Ontological representation of concepts, empowering the semantic alignment with generalizations and specializations.
- Simpler and explicit functional API.

## Install

```
pip install .
```

## How To

⚠️ The API definition is highly unstable because of the work-in-progress nature of the project. ⚠️

After having loaded annotated ImageNet dataset.

```python
from anonlibrary.loader import get_dataset
dataset = get_dataset('/data/imagenet/, style='imagenet')
images, ontology, annotations = dataset
```

Get the list of names for the hookables modules for a given model.

```python
from anonlibrary.loader.model import get_names
modules = get_names(model)
```

Record the activations of the last module.

```python
from anonlibrary import semalign as sa

activations = sa.record_activations(model,
                                   modules[-1:],
                                   images,
                                   batch=8,
                                   cache='/data/results/',
                                   gpu=False)
```

Compute the thresholds for the activation masks.

```python
thresholds = sa.compute_thresholds(activations,
                                  batch_size=8,
                                  n_workers=4,
                                  cache='/data/results/')
```

Compute the semantic alignment estimated using the IoU metric.

```python
iou = sa.compute_sigma(activations, annotations, thresholds,
                       ontology, n_workers=16, cache='/data/results',
                       batch_size=8, visit='flat', style='iou')
```
