import argparse

def parse_args():
    parser = argparse.ArgumentParser(description="Load arguments", formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    
    ### Experiment settings
    parser.add_argument("--exp_name", type=str, default="test", help="The name of the experiment.")
    
    ### Environment settings
    parser.add_argument("--seed", type=int, default=11, help="Random seed for running experiments.")
    parser.add_argument("--gpu_id", type=int, default=0, help="GPU ID.")
    
    ### Model settings
    parser.add_argument("--model_name", type=str, default="llama-3", help="The language model adopted as the user.")
    parser.add_argument("--max_seq_len", type=int, default=512, help="The maximum of the sequence, no more than 8192.")
    parser.add_argument("--max_batch_size", type=int, default=4, help="The maximum of the batch size.")
    
    ### Task mode
    parser.add_argument("--task_mode", type=str, default="linear_classification", help="The task mode to be tested.")
    parser.add_argument("--pred_mode", type=str, default="all", choices=["all", "single"], help="The prediction mode for conventional methods.")
    
    ### Data Settings
    parser.add_argument("--precision", type=int, default=None, help="The precision of data in each task.")
    parser.add_argument("--circle_task_noise", type=float, default=0.03, help="The noise coefficient of circle task.")
    parser.add_argument("--num_samples", type=int, default=128, help="The number of data samples in tasks.")
    parser.add_argument("--num_classes", type=int, default=2, help="The number of classes in tasks.")
    
    ### Prompt settings
    parser.add_argument("--prompt_mode", type=str, default="standard", help="The prompt mode.")
    
    ### Algorithm settings
    parser.add_argument("--ml_alg", type=str, default=None, help="Machine learning algorithms.")
    parser.add_argument("--prob_type", type=str, default="standard", 
                        choices=["standard", "ml-only", "uniform", "random"], help="The type of probability.")
    parser.add_argument("--hybrid_type", type=str, default="prob", 
                        choices=["prob", "hsic"], help="The type of perform classification in the hybrid way.")
    
    args = parser.parse_args()
    return args