import numpy as np
from src.task_generator import generate_linear_task, generate_circle_task, generate_moon_task


def generate_grid_data(support_data:np.ndarray, num_coord:int=50) -> np.ndarray:
    
    min_x, min_y = list(np.min(support_data, axis=0))
    max_x, max_y = list(np.max(support_data, axis=0))
    
    x_coordinates = np.linspace(min_x-0.2, max_x+0.2, num_coord)
    y_coordinates = np.linspace(min_y-0.2, max_y+0.2, num_coord)
    
    mesh_x_coord, mesh_y_coord = np.meshgrid(x_coordinates, y_coordinates.transpose())
    
    res = []
    for i in range(num_coord):
        for j in range(num_coord):
            res.append([mesh_x_coord[i][j], mesh_y_coord[i][j]])
    return np.array(res)
    