import os
import random
import torch

import numpy as np
from fastchat.model import get_conversation_template

def set_seed(seed_id:int=42):
    """
    Set random seed for the experiment for reproduction. Default: 42.
    """
    random.seed(seed_id)
    np.random.seed(seed_id)
    torch.manual_seed(seed_id)
    torch.cuda.manual_seed(seed_id)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False
    os.environ["PYTHONHASHSEED"] = str(seed_id)    


def conversation_temp(template):
    template = get_conversation_template(template)
    if template.name == "llama-2":
        template.sep2 = template.sep2.strip()
    return template