class Configure:
    def __init__(self, data_name, src_model_name, tgt_model_name, subtask_code=None):
        self.data_name = data_name
        self.src_model_name = src_model_name
        self.tgt_model_name = tgt_model_name
        self.model_name = tgt_model_name

        # ========== ABLATION STUDY CONFIGURATION ==========
        self.ABL0_APPROACH = 'nova'
        # for RQ2
        self.ABL2_ABLATION_RATIO = 1.0  # 1/1 1/4 1/16 1/64 1/256
        self.ABL2_ABLATION_WHICH = 'none'  # autoly evenly layerly maskmax maskmin none

        # refresh
        if subtask_code is not None:
            self._refresh(subtask_code)

    def _refresh(self, subtask_code: str):
        subtask_details = subtask_code.split('.')
        if len(subtask_details) != 3:
            return None
        subtask_type, subtask_key, subtask_value = subtask_details

        assert subtask_type in ['approach', 'locating', 'estimating', 'planning']
        if subtask_type == 'approach':
            assert subtask_key in ['0', '1']
            if subtask_key == '0':
                assert subtask_value in ['finetune', 'star', 'nova']
                self.ABL0_APPROACH = subtask_value
            if subtask_key == '1':
                which, ratio = subtask_value.split('-')
                self.ABL2_ABLATION_WHICH = str(which)
                self.ABL2_ABLATION_RATIO /= int(ratio)
        else:
            raise NotImplementedError
