from transformers import AutoTokenizer


# Load the Llama3-8B tokenizer
tokenizer = AutoTokenizer.from_pretrained("meta-llama/Meta-Llama-3-8B")

# Example usage
# input_text = "positive"  # 36590
# input_text = "Positive"  # 36590
# input_text = "good"  # 19045
input_text = "straightforward"

# Tokenize and get labels
tokenized_output = tokenizer(input_text, return_tensors="pt")

# Print results
print("Original text:", input_text)
print("Token IDs:", tokenized_output["input_ids"])

# Decode tokens to see the actual tokens
tokens = tokenizer.convert_ids_to_tokens(tokenized_output["input_ids"][0])
print(f"Tokens:{tokens=}")
