STRATEGY = "migrate"
DATE_FORMAT = "%Y%m%d"

### WORKSPACE
RELATIVE_REPO_FILE = "relative_repos.jsonl"
POSSIBILITY_FILE = "possibility.jsonl"

TEST_GEN_INSTRUCTION = """
<uploaded_files>
{workspace_dir_name}
</uploaded_files>

I've uploaded a {language} code repository in the directory {workspace_dir_name}. 

Belowing is a issue occurred in another repository.
<issue>
{issue}
</issue>

Since the issue related to some functionality of the current repository, your task is to add some unit tests to current repository to test functionality related to the issue.
I will take care of all changes to any of the non-test files. This means you DON'T have to modify the actual logic and ONLY have to update test logic and tests!
ALL TESTS YOU ADD SHOULD PASSED! 

Follow these steps to create effective test cases:
1. As a first step, it might be a good idea to `cd {workspace_dir_name}` and explore the repo to familiarize yourself with its structure.
2. Navigate the repo to familiarize yourself with the test framework, understand how to run tests and how to add a unit tests.
3. Find the funtions/classes/modules that are related to the issue.
4. Add unit tests to the functions/classes/modules to test the functionality related to the issue.
5. Run the test framework and make sure the test added in <test_patch> should actually run and pass.
6. If the added test fails, only reason is the added test is not correct, you should fix the added test and return to step 4.
"""

MIGRATE_INSTRUCTION = """
<uploaded_files>
{workspace_dir_name}
</uploaded_files>

I've uploaded a {language} code repository in the directory {workspace_dir_name}. Consider the following issue description:
<issue>
{issue}
</issue>

I've add some unit tests to the repository to test the functionality related to the issue. Following patch is the changes made to add the tests:
<test_patch>
{test_patch}
</test_patch>

Your task is to make changes to the repository in the {workspace_dir_name} directory to implement the issue.
The development {language} environment is already set up for you (i.e., all dependencies already installed), so you don't need to install other packages.

Follow these steps to implement the issue in the current repository:
0. As a first step, it might be a good idea to `cd {workspace_dir_name}` and explore the repo to familiarize yourself with its structure.
1. Analyzing the issue description, it might be a good idea to explore the repo to familiarize yourself with its structure and find the code that can be modified to implement the issue.
2. Edit the source code of the repo to implement the issue in a realistic way, don't leave any comments in the code and any naming with issue infomation.
3. Run the test suites to check there is no compilation errors and the issue does not affect functionalities unrelated to the issue. If not, refine your changes and return to step 2.
4. The test added in <test_patch> should fail now and the failure should behave as the issue described, catch the exception in order to make other tests run.
5. Run git diff to view your changes and ensure there is no comments you left in the code.
"""

ISSUE_ABSTRACT = """
Consider the following pull request that fixes a bug:
<pull_request>
   <body>
   {body}
   </body>
   <diff>
   {diff}
   </diff>
</pull_request>

Your task is to abstract the bug pattern from the pull request, focusing exclusively on systemic issues that require changes in multiple locations across the codebase.

Here is an example of a complex bug pattern that requires multiple edits:
<pull_request>
   <body>
   Fix inconsistent error handling across API endpoints

   Multiple API endpoints were handling validation errors differently, leading to inconsistent error responses and poor user experience. Some endpoints returned 400 status codes while others returned 500, and error message formats varied. This PR standardizes error handling across all user-facing endpoints to provide consistent behavior.

   The fix involves:
   - Updating user registration endpoint error handling
   - Fixing profile update validation responses  
   - Standardizing login error messages
   - Adding consistent error formatting in shared utilities

   Fixes #456
   </body>
   <diff>
   @@ -8,7 +8,8 @@ class UserController:
        def register(self, user_data):
            if not self.validate_user_data(user_data):
   -            return {{"error": "Bad input"}}, 500
   +            return {{"error": "Invalid user data", "details": self.get_validation_errors(user_data)}}, 400
   
   @@ -22,7 +23,8 @@ class UserController:
        def update_profile(self, user_id, profile_data):
            if not self.validate_profile_data(profile_data):
   -            raise Exception("Validation failed")
   +            return {{"error": "Invalid profile data", "details": self.get_validation_errors(profile_data)}}, 400
   
   @@ -35,6 +37,7 @@ class AuthController:
        def login(self, credentials):
            if not self.validate_credentials(credentials):
   -            return {{"message": "Login failed"}}, 500
   +            return {{"error": "Invalid credentials", "details": "Username or password incorrect"}}, 401
   
   @@ -5,6 +5,10 @@ class ValidationUtils:
   +    def get_validation_errors(self, data):
   +        # Standardized error formatting
   +        return [str(error) for error in self.validator.errors(data)]
   +
        def validate_user_data(self, data):
            return self.validator.is_valid(data)
   </diff>
</pull_request>

Follow this pattern when abstracting the bug - identify systemic issues that manifest across multiple files and functions:

```md
### Bug Pattern

**Issue Type**: Inconsistent Error Handling / API Response Standardization

**Core Problem**: 
The application lacks consistent error handling patterns across similar functions or modules, leading to unpredictable behavior and poor user experience. Different parts of the codebase handle similar error conditions in incompatible ways.

**Technical Context**:
- API endpoints or service methods that perform similar validation or processing
- Error handling logic scattered across multiple controllers, services, or utility functions
- Inconsistent status codes, error message formats, or exception handling approaches
- Missing standardized error response structures

**Symptom**:
- Different error responses for similar failure conditions
- Inconsistent HTTP status codes across related endpoints
- Varying error message formats that confuse API consumers
- Some functions throw exceptions while others return error objects

**Root Cause Pattern**:
- Lack of centralized error handling utilities or standards
- Copy-paste development without following established patterns
- Missing shared validation or error formatting functions
- Inconsistent exception handling strategies

**Impact Scope**:
Multiple locations typically affected:
- All API endpoints that perform user input validation
- Service layer methods that process similar data types
- Controller functions handling authentication or authorization
- Utility functions used for data processing or validation
- Error response formatting across different modules
```

Please wrap the bug pattern in the following format:
```md
.. the bug pattern ..
```
"""

ISSUE_DIRECT = """
The pull in <pr> contains a bug and it's fix patch.
<pr>
   <body>
   {body}
   </body>
   <diff>
   {diff}
   </diff>
</pr>
"""

MIGRATE_POSSIBILITY = """
You are a senior software engineer. 
You are given a pull request from another repository.
You are going to check, response True in final answer if the pull request is a bug fix or a feature addition, and response False if the pull request is just fixing some error messages or documentations.
1. is the pull request a bug fix or a feature addition
2. is the pull request non-trivial, just fixing error messages, docs, also, this not-related to external dependencies.
3. if some functionality related to the bug or feature exists in the current repository.

Belowing is the description of the pull request:
<pull_request>
   <body>
   {body}
   </body>
   <diff>
   {diff}
   </diff>
</pull_request>

Belowing is the readme and the test suite of the current repository:
<current_repo>
   <readme>
   {readme}
   </readme>
   <test_suite>
   {test_suite}
   </test_suite>
</current_repo>


Think Step by Step with following questions
1. What is the bug fixed or the feature added in the pull request?
2. What is the related functionality of the bug?
3. Does the current repository have the related functionality:
    1. If yes, what is the related functionality?
4. Is it possible to introduce the bug/feature in the current repository?

Note:
- The language of repos does not matter, you should focus on the functionality of the bug.

Respond with python list with two elements, "exists", "reason", in the following format:
```python
[True/False, "The pull request is a bug fix or a feature addition, related to ...., the current repository has the related functionality."] 
```
"""

DIFF_PYTHON = """
```python
### mathweb/flask/app.py
<<<<<<< SEARCH
from flask import Flask
=======
import math
from flask import Flask
>>>>>>> REPLACE
```
"""

DIFF_JAVA = """
```java
### src/bin/Main.java
<<<<<<< SEARCH
import java.io.Scanner;
=======
import java.io.Scanner;
import java.math.BigInteger;
>>>>>>> REPLACE
```
"""

DIFF_GO = """
```go
### api/client.go
<<<<<<< SEARCH
import (
    "fmt"
)
=======
import (
    "fmt"
    "io"
)
>>>>>>> REPLACE
```
"""

DIFF_RUST = """
```rust
### src/build.rs
<<<<<<< SEARCH
fn main() {
    let version = "1.0";
}
=======
fn main() {
    let version = "2.0";
}
>>>>>>> REPLACE
```
"""

DIFF_CPP = """
```cpp
### src/main.cpp
<<<<<<< SEARCH
#include <cstdio>
=======
#include <cstdio>
#include <cstdlib>
>>>>>>> REPLACE
```
"""

DIFF_C = """
```c
### src/main.c
<<<<<<< SEARCH
#include <cstdio>
=======
#include <cstdio>
#include <cstdlib>
>>>>>>> REPLACE
```
"""

DIFF_TYPESCRIPT = """
```typescript
### src/main.ts
<<<<<<< SEARCH
import {
    foo
} from "./utils";
=======
import {
    foo
    bar
} from "./utils";
>>>>>>> REPLACE
```
"""

DIFF_JAVASCRIPT = """
```javascript
### src/main.js
<<<<<<< SEARCH
import {
    foo
} from "./utils";
=======
import {
    foo
    bar
} from "./utils";
>>>>>>> REPLACE
```
"""

DIFF_EXAMPLES = {
    "python": DIFF_PYTHON,
    "java": DIFF_JAVA,
    "go": DIFF_GO,
    "rust": DIFF_RUST,
    "cpp": DIFF_CPP,
    "c": DIFF_C,
    "ts": DIFF_TYPESCRIPT,
    "js": DIFF_JAVASCRIPT,
}
