path_prefix=""

CUDA_VISIBLE_DEVICES=2,3 nohup llamafactory-cli train \
    --stage sft \
    --do_train \
    --model_name_or_path $path_prefix/DeepSeek-R1-Distill-Qwen-1___5B \
    --dataset s1r1-mix-budget \
    --dataset_dir $path_prefix/data \
    --deepspeed $path_prefix/deepspeed/ds_z3_config.json \
    --template deepseek3 \
    --finetuning_type full \
    --output_dir $path_prefix/ckps/s1r1-mix-budget-06/ \
    --overwrite_cache \
    --overwrite_output_dir \
    --cutoff_len 16384 \
    --preprocessing_num_workers 16 \
    --per_device_train_batch_size 1 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 2 \
    --lr_scheduler_type cosine \
    --logging_steps 10 \
    --warmup_ratio 0.1 \
    --save_steps 500 \
    --eval_steps 500 \
    --evaluation_strategy steps \
    --load_best_model_at_end \
    --learning_rate 5e-5 \
    --num_train_epochs 1 \
    --max_samples 20000 \
    --val_size 0.1 \
    --plot_loss \
    --bf16 > $path_prefix/log/sft_s1r1-mix-budget-06.log 2>&1 &