
## How to run

Install dependencies

```bash

# [OPTIONAL] create conda environment
conda create -n myenv python=3.8
conda activate myenv

# install pytorch according to instructions
# https://pytorch.org/get-started/

# install requirements
pip install -r requirements.txt
```

Train model with default configuration

```bash
# train on CPU
python train.py trainer=cpu

# train on GPU
python train.py trainer=gpu
```

Train model with chosen experiment configuration from [configs/experiment/](configs/experiment/)

```bash
python train.py experiment=experiment_name.yaml
```

As an example, if you want to run the linear-DynGFN experiment on the linear dynamic system data, run this script
```bash
python train.py experiment=linear_linsol_dyn_gfn.yaml seed=13,29,42,73,91
```

You can override any parameter from command line like this

```bash
python train.py trainer.max_epochs=20 datamodule.batch_size=64
