custom_imports = dict(
    imports=[
        'dataset.missing_person', 
        'metrics.missing_person_metric'
    ],
    allow_failed_imports=False
)

_base_ = [
    "_base_/default_runtime.py", 
    "_base_/schedules/schedule_1x.py",
    "models/yolox/yolox_tiny.py",
    # "evaluator/missing_person_evaluator.py",
    "data/missing_person_yolox_tiny.py",
    'evaluator/missing_person_v3_evaluator.py',
    # "runner/train.py",
    # "optimizer.py",
]


# training settings
max_epochs = 300
num_last_epochs = 15
# interval = 10
interval = 1

train_cfg = dict(max_epochs=max_epochs, val_interval=interval)

# optimizer
# default 8 gpu
base_lr = 0.01
optim_wrapper = dict(
    type='OptimWrapper',
    optimizer=dict(
        type='SGD', lr=base_lr, momentum=0.9, weight_decay=5e-4,
        nesterov=True),
    paramwise_cfg=dict(norm_decay_mult=0., bias_decay_mult=0.))

# learning rate
param_scheduler = [
    dict(
        # use quadratic formula to warm up 5 epochs
        # and lr is updated by iteration
        # TODO: fix default scope in get function
        type='mmdet.QuadraticWarmupLR',
        by_epoch=True,
        begin=0,
        end=5,
        convert_to_iter_based=True),
    dict(
        # use cosine lr from 5 to 285 epoch
        type='CosineAnnealingLR',
        eta_min=base_lr * 0.05,
        begin=5,
        T_max=max_epochs - num_last_epochs,
        end=max_epochs - num_last_epochs,
        by_epoch=True,
        convert_to_iter_based=True),
    dict(
        # use fixed lr during last 15 epochs
        type='ConstantLR',
        by_epoch=True,
        factor=1,
        begin=max_epochs - num_last_epochs,
        end=max_epochs,
    )
]

# default_hooks = dict(
#     checkpoint=dict(
#         interval=interval,
#         max_keep_ckpts=3  # only keep latest 3 checkpoints
#     ))
# default_hooks = dict(
#     checkpoint=dict(
#         type="CheckpointHook",
#         save_best="coco/bbox_mAP",
#         rule="greater"
#     )
# )

default_hooks = dict(
    checkpoint=dict(
        type="CheckpointHook",
        save_best="coco/bbox_mAP",
        rule="greater",
        max_keep_ckpts=2
    )
)

custom_hooks = [
    dict(
        type='YOLOXModeSwitchHook',
        num_last_epochs=num_last_epochs,
        priority=48),
    dict(type='SyncNormHook', priority=48),
    dict(
        type='EMAHook',
        ema_type='ExpMomentumEMA',
        momentum=0.0001,
        update_buffers=True,
        priority=49)
]

# NOTE: `auto_scale_lr` is for automatically scaling LR,
# USER SHOULD NOT CHANGE ITS VALUES.
# base_batch_size = (8 GPUs) x (8 samples per GPU)
auto_scale_lr = dict(base_batch_size=64)