_base_ = [
  "models/faster_rcnn.py",
  "runner/train.py",
  "evaluator/coco_evaluator.py",
  # "/mnt/home/jeongjun/layout_diffusion/additional_obj_det_models/tmp/mmdetection/configs/_base_/datasets/coco_detection.py",
]
default_scope = 'mmdet'
optim_wrapper = dict(
    type='OptimWrapper',
    optimizer=dict(type='SGD', lr=0.01, momentum=0.9, weight_decay=0.0001))
optimizer_config = dict(_delete_=True, grad_clip=dict(max_norm=35, norm_type=2))

default_hooks = dict(
    checkpoint=dict(
        type="CheckpointHook",
        save_best="coco/bbox_mAP",
        rule="greater"
    )
)

randomness = dict(
    seed=0,
    diff_rank_seed=True,
    # deterministic=True
    deterministic=False
)

train_cfg = dict(
    type='EpochBasedTrainLoop',  # The training loop type. Refer to https://github.com/open-mmlab/mmengine/blob/main/mmengine/runner/loops.py
    max_epochs=29,  # Maximum training epochs
    val_interval=1)  # Validation intervals. Run validation every epoch.