custom_imports = dict(
    imports=[
        'dataset.missing_person', 
        'metrics.missing_person_metric'
    ],
    allow_failed_imports=False
)

_base_ = [
  "_base_/default_runtime.py",
  "_base_/schedules/schedule_1x.py",
  "models/retinanet/retinanet_missing_person.py",
  "models/retinanet/retinanet_tta.py",
#   "evaluator/missing_person_evaluator.py",
#   "data/missing_person_config.py",
    'data/missing_person_v3_config.py',
    'evaluator/missing_person_v3_evaluator.py',
]

default_scope = 'mmdet'


default_hooks = dict(
    checkpoint=dict(
        type="CheckpointHook",
        save_best="coco/bbox_mAP",
        rule="greater",
        max_keep_ckpts=2
    )
)

optim_wrapper = dict(
    type='OptimWrapper',
    optimizer=dict(type='SGD', lr=0.005, momentum=0.9, weight_decay=0.0001))

# randomness = dict(
#     seed=2024,
#     diff_rank_seed=True,
#     deterministic=True
#     # deterministic=False
# )
