_base_ = [
  "models/retinanet.py",
  "runner/train.py",
  "evaluator/coco_evaluator.py",
]
default_scope = 'mmdet'
optim_wrapper = dict(
    type='OptimWrapper',
    optimizer=dict(type='SGD', lr=0.01, momentum=0.9, weight_decay=0.0001))
# optim_wrapper = dict(
#     type='OptimWrapper',
#     optimizer=dict(type='SGD', lr=0.005, momentum=0.9, weight_decay=0.0001))
optimizer_config = dict(_delete_=True, grad_clip=dict(max_norm=35, norm_type=2))

default_hooks = dict(
    checkpoint=dict(
        type="CheckpointHook",
        save_best="coco/bbox_mAP",
        rule="greater"
    )
)

randomness = dict(
    seed=2024,
    diff_rank_seed=True,
    deterministic=True
    # deterministic=False
)
