# Copyright (c) OpenMMLab. All rights reserved.
# from mmengine.optim.optimizer.optimizer_wrapper import OptimWrapper
# from mmengine.optim.scheduler.lr_scheduler import LinearLR, MultiStepLR
# from mmengine.runner.loops import EpochBasedTrainLoop, TestLoop, ValLoop
# from torch.optim.sgd import SGD

# # training schedule for 1x
# train_cfg = dict(type=EpochBasedTrainLoop, max_epochs=12, val_interval=1)
# val_cfg = dict(type=ValLoop)

# optim_wrapper = dict(
#     type=OptimWrapper,
#     optimizer=dict(type=SGD, lr=0.02, momentum=0.9, weight_decay=0.0001))

auto_scale_lr = dict(enable=False, base_batch_size=16)
train_cfg = dict(
    type='EpochBasedTrainLoop',  # The training loop type. Refer to https://github.com/open-mmlab/mmengine/blob/main/mmengine/runner/loops.py
    max_epochs=300,  # Maximum training epochs
    val_interval=1)  # Validation intervals. Run validation every epoch.
# val_cfg = dict(type='ValLoop')  # The validation loop type
# test_cfg = dict(type='TestLoop')  # The testing loop type

param_scheduler = [
    dict(
        type='LinearLR', start_factor=0.001, by_epoch=False, begin=0, end=500),
    dict(
        type='MultiStepLR',
        begin=0,
        end=12,
        by_epoch=True,
        milestones=[8, 11],
        gamma=0.1)
]

# optim_wrapper = dict(
#     type='OptimWrapper',
#     optimizer=dict(type='SGD', lr=0.02, momentum=0.9, weight_decay=0.0001))
optim_wrapper = dict(
    type='OptimWrapper',
    optimizer=dict(type='SGD', lr=0.005, momentum=0.9, weight_decay=0.0001))
optimizer_config = dict(_delete_=True, grad_clip=dict(max_norm=35, norm_type=2))

# Default setting for scaling LR automatically
#   - `enable` means enable scaling LR automatically
#       or not by default.
#   - `base_batch_size` = (8 GPUs) x (2 samples per GPU).
