#/bin/bash

project_dirs=missing_person
exp_name=250422_missing_person_yolox
# cuda_visible_devices=4,5
cuda_visible_devices=4
# cuda_visible_devices=7
# cuda_visible_devices=1
port=29501

gpus=$(echo $cuda_visible_devices | grep -o "," | wc -l)
gpus=$((gpus+1))

echo gpus: $gpus

# config_name=$experiment_name/$seed.yaml
# config_name=/mnt/home/jeongjun/neurips2025/mmdet/exp_config/tmp.yaml

# config_name=exp_config/yolox.yaml
# checkpoint=/mnt/home/jeongjun/neurips2025/mmdet/missing_person/250503_missing_person_yolox_forestperson_v3/best_coco_bbox_mAP_epoch_17.pth
# config_name=exp_config/yolov3.yaml
# checkpoint=/mnt/home/jeongjun/neurips2025/mmdet/missing_person/250503_missing_person_yolov3_forestperson_v3/best_coco_bbox_mAP_epoch_70.pth
# config_name=exp_config/retinanet.yaml
# checkpoint=/mnt/home/jeongjun/neurips2025/mmdet/missing_person/250503_missing_person_retinanet_forestperson_v3/best_coco_bbox_mAP_epoch_9.pth



config_name=exp_config/yolox.yaml
checkpoint=/mnt/home/jeongjun/neurips2025/mmdet/missing_person/250503_missing_person_yolox_forestperson_v3/best_coco_bbox_mAP_epoch_17.pth
# config_name=exp_config/yolo3.yaml
# checkpoint=/mnt/home/jeongjun/neurips2025/mmdet/missing_person/250503_missing_person_yolov3_forestperson_v3/best_coco_bbox_mAP_epoch_70.pth
# config_name=exp_config/faster_rcnn.yaml
# checkpoint=/mnt/home/jeongjun/neurips2025/mmdet/missing_person/250503_missing_person_faster_rcnn_forestperson_v3/best_coco_bbox_mAP_epoch_9.pth
# config_name=exp_config/retinanet.yaml
# checkpoint=/mnt/home/jeongjun/neurips2025/mmdet/missing_person/250423_missing_person_retinanet_annotation_v0.3/best_coco_bbox_mAP_epoch_12.pth
# config_name=exp_config/ssd.yaml
# checkpoint=/mnt/home/jeongjun/neurips2025/mmdet/missing_person/250503_missing_person_ssd_forestperson_v3/best_coco_bbox_mAP_epoch_100.pth


# config_name=exp_config/ssd.yaml
# checkpoint=

if [ "$gpus" -eq 1 ]; then
    echo "Single GPU"
    # CUDA_VISIBLE_DEVICES=$cuda_visible_devices python train.py --config exp_configs/$config_name
    CUDA_VISIBLE_DEVICES=$cuda_visible_devices python inference.py --config $config_name --checkpoint $checkpoint --project_dir $project_dirs --exp_name $exp_name
else
    echo "Multiple GPUs"
    echo "CUDA_VISIBLE_DEVICES=$cuda_visible_devices"

        CUDA_VISIBLE_DEVICES=$cuda_visible_devices python -m torch.distributed.launch \
            --nproc_per_node=$gpus \
            --master-port $port \
            inference.py \
            --config $config_name \
            --launcher pytorch \
            --project_dir $project_dirs \
            --exp_name $exp_name \
            --checkpoint $checkpoint \ 

fi


# config_name=$experiment_name/0.yaml
# bash /mnt/home/jeongjun/layout_diffusion/additional_obj_det_models/coreset/scripts/select_coreset.sh     /mnt/home/jeongjun/layout_diffusion/additional_obj_det_models/exp_configs/$config_name     $cuda_visible_devices     $port
