#!/bin/bash

TOP_PATH=
QA_NAME=nq_test
CONTEXT_NAME=dpr_wiki

CHECKPOINT_PATH=${TOP_PATH}/checkpoint
CHECKPOINT_NAME=
EMBEDDING_OUTPUT_PATH=${CHECKPOINT_NAME}_on_${CONTEXT_NAME}
EMBEDDING_NAME=${EMBEDDING_OUTPUT_PATH}/test_embeddings.pkl_0
SCORE_OUTPUT_PATH=${CHECKPOINT_NAME}_on_${CONTEXT_NAME}

HYDRA_FULL_ERROR=1 CUDA_VISIBLE_DEVICES=4,5,6 python generate_dense_embeddings.py \
	model_file=${CHECKPOINT_PATH}/${CHECKPOINT_NAME}/dpr_biencoder.24 \
	ctx_src=${CONTEXT_NAME} \
	shard_id=0 num_shards=1 \
	output_path=$EMBEDDING_OUTPUT_PATH

HYDRA_FULL_ERROR=1 CUDA_VISIBLE_DEVICES=4,5,6 python dense_retriever.py \
	model_file=${CHECKPOINT_PATH}/${CHECKPOINT_NAME}/dpr_biencoder.24 \
	qa_dataset=${QA_NAME} \
	ctx_datasets=[${CONTEXT_NAME}] \
	encoded_ctx_files=[${TOP_PATH}/embeddings/${EMBEDDING_NAME}] \
	output_path=${SCORE_OUTPUT_PATH} \
	out_file=scores.json