# AAAI2026 Concept-based Activation Steering for Conditional Molecular Generation

This is the code for AAAI 2026 Concept-based Activation Steering for Conditional Molecular Generation submission.

We structure the following repository as follow:

`concept_representation_alignment`: Folder containing code for Concept Activation Steering
- `concept_alignment`: source code for Concept and Property predictor Modules
- `concept_steering`: scripts for running steering experiments with CBM
- `configs` : configuration files for training the CBM
- `concept_alignment_{property}.py`: scripts for computing CAV for specific property
- `create_stimuli_dataset_{property}.py`: scripts for creating stimuli dataset for CAV computation

`reports`: Folder containing scripts to calculate evaluation metrics on generated molecules
- `configs`: configuration files to run specific evaluation on in-dist and OOD settings
- `report_eval.py`: script for running in-dist evaluation
- `report_{property}.py`: script for running OOD evaluation on specific property

`testing`: Folder containing script for running In-Dist and OOD experiments
- `configs`: Configuration files for running In-Dist and OOD experiments with base models and CAV models
- `conditional_evaluation_cav_{property}.py`: Script for running OOD experiments with CAV on specific properties
- `conditional_evaluation_chemlactica_{property}.py`: Script for running OOD experiments with base models on specific properties
- `eval.py`: Script for running In-Dist experiments with base models
- `oled_eval.py`: Script for running xtb-Conjugated experiments
- `tdc_eval_cav.py`: Script for running In-Dist experiments with CAV models

`training`: Folder containing scripts for finetuning base models
- `finetune.py`: Script for finetuning base models

`utils`: Folder containing scripts for different utilities
- `callback.py`: callback utils for training CBM
- `eval_metrics`: rdkit evaluation metrics

`environment.yml`: environment file for virtual environment

`tdc_data`: Data Folder