from rdkit import Chem
from rdkit.Chem import Crippen, QED
from rdkit import RDLogger

RDLogger.DisableLog('rdApp.*')

def is_valid_smiles(smiles):
    try:
        mol = Chem.MolFromSmiles(smiles)
        return mol is not None
    except Exception:
        return False

def clogp(smiles):
    """Returns clogp or NaN if invalid/uncomputable."""
    try:
        mol = Chem.MolFromSmiles(smiles)
        if mol is None:
            return float('nan')
        return Crippen.MolLogP(mol)
    except Exception:
        return float('nan')

def qed(smiles):
    """Returns QED or NaN if invalid/uncomputable."""
    try:
        mol = Chem.MolFromSmiles(smiles)
        if mol is None:
            return float('nan')
        return QED.qed(mol)
    except Exception:
        return float('nan')
