# Env Setup

We recommend using conda for enviornment management. 

```shell 

# create a virtual env
conda create -n s2vdit python=3.10
# activate virtual environment
conda activate s2vdit

pip install -r requirements.txt
```

# Commands to Run

We provide the shell scripts for calibration CogVideoX.


### 1. Download diffusers CogVideoX checkpoints

- Download the CogVideoX-5B  from [this link](https://huggingface.co/THUDM/CogVideoX-5b)

### 2. Calibration for S2Q-VDiT

- `bash run.sh`: conducting calibration process

```shell
CUDA_VISIBLE_DEVICES=xx python run_quantize.py \
    --model_id xxx/CogVideoX-5b # your path to ckpt \
    --dtype s2quant_w4a6 --use_gptq --exp_name # you exp name \

```

### 3. Inference for S2Q-VDiT

- `bash run.sh`: conducting inference process

```shell
CUDA_VISIBLE_DEVICES=xx python run_quantize.py \
    --model_id xxx/CogVideoX-5b # your path to ckpt \
    --dtype s2quant_w4a6 --use_gptq --exp_name # you exp name \
    --resume_s2 --resume_gptq

```

