RES_MODEL="./model/Llama2-7b-hf" 
OUTPUT_PATH="./output/math-test-Llama-2-7b"
DATA_PATH="./data"

python train.py \
    --model_name_or_path $RES_MODEL \
    --use_test True \
    --full_finetune False \
    --bf16 \
    --bits 16 \
    --data_path $DATA_PATH \
    --sub_task python:100000 \
    --dataset_split train \
    --dataset_field instruction output \
    --output_dir $OUTPUT_PATH \
    --num_train_epochs 1 \
    --lora_rank 128 \
    --lora_alpha 128 \
    --share_r 32 \
    --target_r 80 \
    --tinit 235 \
    --tfinal 780 \
    --total_step 1562 \
    --deltaT 10 \
    --orth_reg_weight 0.1 \
    --lora_dropout 0 \
    --model_max_length 380 \
    --per_device_train_batch_size 4 \
    --gradient_accumulation_steps 16 \
    --save_strategy "steps" \
    --save_steps 600 \
    --save_total_limit 1 \
    --learning_rate 1e-5 \
    --weight_decay 0 \
    --warmup_ratio 0.03 \
    --logging_steps 1 \
    --lr_scheduler_type "cosine" \
    --report_to "wandb" 

python merge_adapter.py \
    --base_model $RES_MODEL \
    --adapter $OUTPUT_PATH/checkpoint-1562/adapter_model \
    --output_path $OUTPUT_PATH \
    --method "test"