import torch
import numpy as np
import pickle

STACK_EMB_HIDDEN_DIM_1 = 1024
COMMON_DIM = 8

FLOW_LENGTH = 64

INPUT_DIM_A = 5 
INPUT_DIM_B = 5
OUTPUT_DIM = 10 
ORTHOG_VECTOR = torch.tensor(np.ones(OUTPUT_DIM), dtype=torch.float32) 
assert OUTPUT_DIM == ORTHOG_VECTOR.shape[0]
PROJ_STYLE = 'convex_boundary_norm'

AMB_LOWER_BOUND_A = -1.0
AMB_UPPER_BOUND_A = 1.0
AMB_LOWER_BOUND_B = -1.0
AMB_UPPER_BOUND_B = 1.0


OUTPUT_MASK=None

NUM_SAMPLES=int(2e4)

# Training
NUM_EPOCHS = 20000
BATCH_SIZE = 2048

AUTOENCODER_BALANCE = [1.0, 1.0]
NFLOW_LOSS_DICT = {
    'nll_loss': 0.5, 
    'lipschitz_loss': 1.5, 
    'perturb_loss': 0.5, 
    'geodesic_repulsion_loss': 1.0, 
}

SIGMA_REPULSION = 0.08
NF_LEARN_RATE = 0.05
LAMBDA_LIPSCHITZ = 0.5

EARLY_STOPPING_PATIENCE = 50
EARLY_STOPPING_MIN_DELTA = 1.0e-4

# Bandit Params

BURN_IN_T = 20
BANDIT_T = 200
C_STACKMAN = 1e4
C_T = lambda t: C_STACKMAN*np.sqrt(np.log(t+1) / (t+1))

# NPG
KAPPA_LIU_RONG = 8.0

GAMMA_0 = 1.0
GAMMA_1 = -1.0
SIGMA_DEMAND_NPG = 0.3

A_LOWER = 0.0
A_UPPER = 1.0
B_LOWER = 0.0
B_UPPER = 1.0
P_LOWER = A_LOWER
P_UPPER = np.inf

A_UPPER_RAND = 1.0
B_UPPER_RAND = 1.0

# Stack1 game
A_UPPER_STACK1 = 1
B_UPPER_STACK1 = 1
STDEV_R1 = 6.0

THETA_1_S1 = 4.0
THETA_2_S1 = 1.0
ALPHA_1_S1 = 1.0
ALPHA_1_S1 = 2.0
LAMBDA_S1 = 0.9

# StackN game
THETA_A = np.array([-0.59865848, -0.95071431, 0.15601864, -0.73199394, 0.37454012])
THETA_B = np.array([-0.86617615, 0.70807258, -0.15599452, 0.60111501, -0.05808361])

STDEV_RN = 25
A_UPPER_STACK_N = 1
B_UPPER_STACK_N = 1

C_A = 5.0 # Define the constraints C_A and C_B for the L1 norm
C_B = 5.0

# UCB
UCB_EXPLORE = 1e-3
UCB_DISCRETIZATION = 200

# Experiments
MC_DISPLAY = 5000

def is_pickleable(obj):
    try:
        pickle.dumps(obj)
    except (pickle.PicklingError, TypeError):
        return False
    return True

globals_to_save = {key: value for key, value in globals().items() if not key.startswith("__") and not callable(value) and is_pickleable(value)}

with open('saved_models/globals_config.pkl', 'wb') as f:
    pickle.dump(globals_to_save, f)