from games.npg import *
import numpy as np
from common.variables import *
from common.helper_funcs import *
from common.randomization_tools import *
from ol.oful_proj import *
from common.variables import *
import copy

import matplotlib.pyplot as plt
import matplotlib.pyplot as plt


game = NewsvendorPricingGame(
    gamma_0=GAMMA_0, 
    gamma_1=GAMMA_1, 
    sigma=SIGMA_DEMAND_NPG, 
    T=BURN_IN_T, 
    leader_strategy=random_leader_strategy, 
    follower_strategy=reactive_follower_strategy
)

game.simulate()

leader_rewards, follower_rewards = game.get_rewards()
leader_actions, follower_actions = game.get_actions()

history = game.get_history()

leader_cumulative_rewards = np.cumsum(leader_rewards)
follower_cumulative_rewards = np.cumsum(follower_rewards)


game_liu_rong = copy.deepcopy(game)
game_liu_rong.leader_strategy = optimistic_leader_strategy
game_liu_rong.follower_strategy = reactive_follower_liu_rong_strategy

game_liu_rong.simulate(BANDIT_T)

leader_rewards_full, follower_rewards_full = game_liu_rong.get_rewards()
leader_actions_full, follower_actions_full = game_liu_rong.get_actions()

leader_rewards_liu_rong = leader_rewards_full[BURN_IN_T:]
follower_rewards_liu_rong = follower_rewards_full[BURN_IN_T:]
leader_actions_liu_rong = leader_actions_full[BURN_IN_T:]
follower_actions_liu_rong = follower_actions_full[BURN_IN_T:]

history_liu_rong = game_liu_rong.get_history()[BURN_IN_T:]

leader_cumulative_rewards_liu_rong = np.cumsum(leader_rewards_liu_rong)
follower_cumulative_rewards_liu_rong = np.cumsum(follower_rewards_liu_rong)

plt.figure(figsize=(10, 6))
plt.plot(leader_cumulative_rewards_liu_rong, label="Leader's Cumulative Reward")
plt.plot(follower_cumulative_rewards_liu_rong, label="Follower's Cumulative Reward")
plt.title("Cumulative Rewards of Leader and Follower over Time")
plt.xlabel("Iteration")
plt.ylabel("Cumulative Reward")
plt.legend()
plt.grid(True)
plt.show()

for entry in history_liu_rong:
    print(f"Iteration {entry['iteration']}:")
    print(f"  Leader action (a): {entry['leader_action']}")
    print(f"  Follower actions (b, p): {entry['follower_action']}")
    print(f"  Leader reward: {entry['leader_reward']}")
    print(f"  Follower reward: {entry['follower_reward']}")
    print()
