import torch
import torch.nn as nn
import torch.nn.functional as F
from torch.autograd import Variable


def mart_loss(model,
              x_natural,
              y,
              acc_ref,
              optimizer,
              step_size=0.007,
              epsilon=0.031,
              perturb_steps=10,
              perturb_steps_prime=2,
              beta=6.0,
              distance='l_inf'):
    kl = nn.KLDivLoss(reduction='none')
    x_adv = x_natural.clone().detach()

    step_size_prime = 1.7 * epsilon / 2
    batch_size = len(x_natural)

    model.train()

    logits = model(x_natural)


    model.eval()
    
    sign = 2 * ((logits.max(1)[1] == y).float()) - 1
    pred_var = (torch.var(F.softmax(logits, dim=1), dim=1) * sign).detach()
    gamma = 0.8
    p = torch.clamp(1.0-acc_ref, 0, 0.99) # in [0, 1]

    th = F.relu(torch.quantile(pred_var, p))

    pred_robust = (pred_var > th).int()
    pred_boundary = torch.logical_and(pred_var <= th, pred_var >= 0).int()

    r_size = pred_robust.sum()
    b_size = pred_boundary.sum()

    #print(r_size.item())
    #print((batch_size-r_size-b_size).item())
    
    robust_index = pred_robust.nonzero()[:, 0]
    boundary_index = pred_boundary.nonzero()[:, 0]

    index = torch.cat((boundary_index, robust_index), 0)
    
    x1, y1 = x_natural[index, :, :, :], y[index]
    a1 = torch.cat((torch.ones_like(boundary_index) * step_size, torch.ones_like(robust_index) * step_size_prime), 0)
    a1 = a1.reshape((a1.shape[0], 1, 1, 1))
    # generate adversarial example
    x_adv1 = x1.detach() + 0.001 * torch.randn(x1.shape).cuda().detach()


    # generate adversarial example
    for _ in range(perturb_steps_prime):
        x_adv1.requires_grad_()
        with torch.enable_grad():
            loss_ce = F.cross_entropy(model(x_adv1), y1)
        grad = torch.autograd.grad(loss_ce, [x_adv1])[0]
        x_adv1 = x_adv1.detach() + a1 * torch.sign(grad.detach())
        x_adv1 = torch.min(torch.max(x_adv1, x1 - epsilon), x1 + epsilon)
        x_adv1 = torch.clamp(x_adv1, 0.0, 1.0)
    
    if b_size > 0:
        x_adv2, x_adv1 = x_adv1[0:b_size].detach(), x_adv1[b_size:].detach()
        x2, y2 = x1[0:b_size], y1[0:b_size]
        a2 = torch.ones_like(y2) * step_size
        a2 = a2.reshape(a2.shape[0], 1, 1, 1)
        for _ in range(perturb_steps-perturb_steps_prime):
            x_adv2.requires_grad_()
            with torch.enable_grad():
                loss_ce = F.cross_entropy(model(x_adv2), y2)
            grad = torch.autograd.grad(loss_ce, [x_adv2])[0]
            x_adv2 = x_adv2.detach() + a2 * torch.sign(grad.detach())
            x_adv2 = torch.min(torch.max(x_adv2, x2 - epsilon), x2 + epsilon)
            x_adv2 = torch.clamp(x_adv2, 0.0, 1.0)

        x_adv[robust_index] = x_adv1
        x_adv[boundary_index] = x_adv2
    else:
        x_adv[robust_index] = x_adv1

    model.train()
    x_adv.requires_grad_(False)
    x_natural.requires_grad_(False)
    #
    #x_adv = Variable(torch.clamp(x_adv, 0.0, 1.0), requires_grad=False)
    # zero gradient
    optimizer.zero_grad()

    #logits = model(x_natural)

    logits_adv = model(x_adv)
    
    batch_acc = gamma * (logits_adv.max(1)[1] == y).detach().float().mean()

    adv_probs = F.softmax(logits_adv, dim=1)

    tmp1 = torch.argsort(adv_probs, dim=1)[:, -2:]

    new_y = torch.where(tmp1[:, -1] == y, tmp1[:, -2], tmp1[:, -1])

    loss_adv = F.cross_entropy(logits_adv, y) + F.nll_loss(torch.log(1.0001 - adv_probs + 1e-12), new_y)

    nat_probs = F.softmax(logits, dim=1)

    true_probs = torch.gather(nat_probs, 1, (y.unsqueeze(1)).long()).squeeze()

    loss_robust = (1.0 / batch_size) * torch.sum(
        torch.sum(kl(torch.log(adv_probs + 1e-12), nat_probs), dim=1) * (1.0000001 - true_probs))
    loss = loss_adv + float(beta) * loss_robust

    return loss, batch_acc
