# Installation
The code has been tested on python 3.9.10

1.  Install pytorch (1.8.0) and other requirements. More info on installation of pytorch 1.8.0 can be found [here](https://pytorch.org/get-started/previous-versions/) .
```
pip install torch==1.7.0 torchvision==0.8.0 torchaudio==0.7.0 
pip install -r requirements.txt
```

2. Add the next line to 37th line of ``<PyTorch Library Folder>/_six.py``:
```
PY3 = sys.version_info[0] == 3
```

3.  Define the environment variables.

```
export BASE_PATH='<path_to_repo>'
export COMET_API_KEY=''
export COMET_PROJECT=''
export COMET_WORKSPACE=''
export PYTHONPATH="$BASE_PATH"
export DATA_PATH="$BASE_PATH/data/raw/"
export SAVED_MODELS_BASE_PATH="$BASE_PATH/data/models/peclr"
export SAVED_META_INFO_PATH="$BASE_PATH/data/models" 
```

4. Download [FreiHand](https://lmb.informatik.uni-freiburg.de/projects/freihand/) and extract the datasets into ``data/raw/freihand_dataset`` of the main PeCLR directory respectively. Evaluation dataset is needed for test. 

# Pretraining 
```
python src/experiments/peclr_training.py --color_jitter --random_crop --rotate --crop -resnet_size 152  -sources freihand --resize -epochs 100 -batch_size 256  -accumulate_grad_batches 16 -save_top_k 1  -save_period 1
```
Trained model is saved in ``data/models/cmoet-default/~~/last.ckpt``.

# Fine tuning
```
python fine_tuning.py --pretrained MODEL_NAME.PTH
```

# Testing
```
python test.py --model MODEL_PATH.PTH
```

You can change loss function settings in function ``LASCon_loss`` of ``src/models/utils.py``. You can see loss function code at ``LASCon.py``

Please refer ``plotting.ipynb`` file for plotting. 