# Code For ROMAO

```bash
python src/main.py --run_online --config=qmix --env-config=sc2 --map_name=5m_vs_6m --remark=save_model --t_max=3100000
python src/main.py --run_online --config=qmix_random --env-config=sc2 --map_name=5m_vs_6m --remark=pert10 --t_max=3100000
python src/main.py --run_ad --config=ad --env-config=sc2 --map_name=5m_vs_6m --remark=pert10 --t_max=31100000
```

# PyMARL-Ext: Extension to Python MARL Framework

PyMARL-Ext is an extension to original [WhiRL](http://whirl.cs.ox.ac.uk)'s [PyMARL](https://github.com/mansicer/pymarl-ext) framework, where we add (or plan to add) the following key features:

- Flexible multi-task and offline training supports
- More multi-agent environment support (i.e., [Google reseach football](https://github.com/google-research/football), [PettingZoo](https://www.pettingzoo.ml), and a default binding for [OpenAI Gym](https://www.gymlibrary.ml) envs)
- More user-friendly experiment recording and logging without `sacred` supporting
- Compatibility with Python >= 3.9
- Docker support with latest `nvidia-docker` images

About PyMARL: [PyMARL](https://github.com/mansicer/pymarl-ext) is [WhiRL](http://whirl.cs.ox.ac.uk)'s framework for deep multi-agent reinforcement learning and includes implementations of the following algorithms. PyMARL is written in PyTorch and uses [SMAC](https://github.com/oxwhirl/smac) as its environment.

## Installation instructions

Build the Dockerfile using 
```shell
cd docker
bash build.sh
```

Set up StarCraft II and SMAC:
```shell
bash install_sc2.sh
```

## Run an experiment 

## Watching StarCraft II replays

`save_replay` option allows saving replays of models which are loaded using `checkpoint_path`. Once the model is successfully loaded, `test_nepisode` number of episodes are run on the test mode and a .SC2Replay file is saved in the Replay directory of StarCraft II. Please make sure to use the episode runner if you wish to save a replay, i.e., `runner=episode`. The name of the saved replay file starts with the given `env_args.save_replay_prefix` (map_name if empty), followed by the current timestamp. 

The saved replays can be watched by double-clicking on them or using the following command:

```shell
python -m pysc2.bin.play --norender --rgb_minimap_size 0 --replay NAME.SC2Replay
```

**Note:** Replays cannot be watched using the Linux version of StarCraft II. Please use either the Mac or Windows version of the StarCraft II client.

## Citing PyMARL 

If you use PyMARL-Ext or PyMARL in your research, please cite the [SMAC paper](https://arxiv.org/abs/1902.04043).

*M. Samvelyan, T. Rashid, C. Schroeder de Witt, G. Farquhar, N. Nardelli, T.G.J. Rudner, C.-M. Hung, P.H.S. Torr, J. Foerster, S. Whiteson. The StarCraft Multi-Agent Challenge, CoRR abs/1902.04043, 2019.*

In BibTeX format:

```tex
@article{samvelyan19smac,
  title = {{The} {StarCraft} {Multi}-{Agent} {Challenge}},
  author = {Mikayel Samvelyan and Tabish Rashid and Christian Schroeder de Witt and Gregory Farquhar and Nantas Nardelli and Tim G. J. Rudner and Chia-Man Hung and Philiph H. S. Torr and Jakob Foerster and Shimon Whiteson},
  journal = {CoRR},
  volume = {abs/1902.04043},
  year = {2019},
}
```

## License

Code licensed under the Apache License v2.0
