import datetime

class _Timer():
    def __init__(self, name, counter):
        self.name = name
        self.counter = counter

    def __enter__(self):
        self.start_time = datetime.datetime.now()

    def __exit__(self, exc_type, exc_val, exc_tb):
        time_delta = datetime.datetime.now() - self.start_time
        self.counter.time_cost_dict[self.name] = self.counter.time_cost_dict.get(self.name, datetime.timedelta(seconds=0)) + time_delta

class Timer():
    def __init__(self):
        self.time_cost_dict = {}
        self.start_time = datetime.datetime.now()
        self.last_time = self.start_time

    def timer(self, name):
        return _Timer(name, self)

    def time_cost_str(self, t, last_t, t_max):
        time_now = datetime.datetime.now()
        total_time = time_now - self.start_time
        time_str = ['Time passed {}'.format(str(total_time).split('.')[0])]
        last_time_interval = time_now - self.last_time
        fps = (t - last_t) / last_time_interval.total_seconds()
        time_str.append('Interactions per second {:>.1f}'.format(fps))
        time_left = datetime.timedelta(seconds=max(0, t_max - t) / fps)
        time_str.append('Estimated time left {}'.format(str(time_left).split('.')[0]))
        for name, cost in self.time_cost_dict.items():
            time_str.append('{} time {:.1f}%'.format(name.title(), cost / total_time * 100))

        self.last_time = time_now
        return ', '.join(time_str)
