# MC-SMoE

## 1. Setup environment

```
conda create -n mcsmoe python=3.9
conda activate mcsmoe
pip install -r requirements.txt
```

## 2. Supervised Fine-tuning

### 2.1 Fine-Tuning _switch-base-32_ & _t5-base_

```shell
bash scripts/t5/finetune-t5.sh
```

```shell
bash scripts/t5/finetune-switch.sh
```

### 2.2 Permutation Alignment for _switch-base-32_

```shell
bash scripts/t5/permute-switch.sh
```

### 2.3 MC-SMoE Merging

```shell
bash scripts/t5/merge-by-usage-frequency-weighted.sh
```

### 2.4 MC-SMoE Compression

```shell
bash scripts/t5/post-merging-losparse.sh
```

### 2.5 Profiling Latency/FLOPs

```shell
bash scripts/t5/profile-flops.sh
```

```shell
bash scripts/t5/profile-latency.sh
```

### 2.6 Pruning Baselines

```shell
bash scripts/t5/task-specific.sh
```

```shell
bash scripts/t5/prune-non-core.sh
```

### 2.7 Merging Baslines

The `strategy` argument can be set to `average`, `repair`, `zipit`, `git-rebasin` for different merging baselines.

```shell
bash scripts/t5/random-merge.sh
```

## 3. Zero-Shot Learning

Similar to the supervised fine-tuning, only change the `t5` to `gpt` in the bash script names.