#!/bin/bash
# This script is used to run LLaVA on a question file with given cfg value and given seed
# check the following variables before running this script

# SAMPLE: whether to sample or not

CUDA_DEVICE=1
DATE=0129
BATCH_SIZE=16
TYPE="black"
QUESTION_FILE="I4_mmc4.json"
MODEL_VERSION=llava-llama-2-7b-chat-lightning-preview

# SEED=42
# cfg=0.0

SEED_lst=(224)
cfg_values=(0.0)

for SEED in "${SEED_lst[@]}"
do
    for cfg in "${cfg_values[@]}"
    do
        ANSWER_DIR=./LLaVA/answers/answer_${TYPE}_${DATE}/answer_${DATE}_${SEED}
        
        echo "Running LLaVA on $QUESTION_FILE with cfg = $cfg, seed = $SEED, batch_size = $BATCH_SIZE"
        
        CUDA_VISIBLE_DEVICES=$CUDA_DEVICE python -m llava.eval.llava_vqa_cfg \
        --question_file $QUESTION_FILE \
        --cfg $cfg \
        --model_path ./checkpoints/$MODEL_VERSION \
        --answer_path $ANSWER_DIR \
        --seed $SEED \
        --batch_size $BATCH_SIZE \
        --sampling \
        --image_folder ./POPE/data/val/val2014/

    done
done
# --sampling
