#/bin/bash

    # "Perception": ["existence", "count", "position", "color", "posters", "celebrity", "scene", "landmark", "artwork", "OCR"],
    # "Cognition": ["commonsense_reasoning", "numerical_calculation", "text_translation", "code_reasoning"]
# TYPE_ls=("commonsense_reasoning" "numerical_calculation" "text_translation" "code_reasoning")
TYPE_ls=(sqa_test)

for TYPE in "${TYPE_ls[@]}"
do
    echo ${TYPE}
    # IMAGE_DIR="/data/linxi/workspace/MME/MME_Benchmark_release_version/${TYPE}/images"
    # IMAGE_DIR="/data/linxi/workspace/POPE/data/val/val2014"
    IMAGE_DIR=/data/linxi/workspace/ScienceQA/test

    if ! [ -f "/data/linxi/workspace/detr/plot_results/scores_boxes_${TYPE}_th0.95.json" ]; then
        CUDA_VISIBLE_DEVICES=1 \
        python /data/linxi/workspace/detr/detr_demo_batch.py \
        --th 0.95 \
        --type ${TYPE} \
        --image_folder ${IMAGE_DIR} \
        --question_path /data/linxi/workspace/ScienceQA/data/scienceqa/ \
        --file_ls test_QCM-LEPA
    fi
    echo "/data/linxi/workspace/POPE/llava_qa/obj/${TYPE}_pred_obj_detr_th0.95.json"
    if [ -f "/data/linxi/workspace/POPE/llava_qa/obj/${TYPE}_pred_obj_detr_th0.95.json" ]; then
        echo "Running standard_obj_detect on ${TYPE}"
        CUDA_VISIBLE_DEVICES=1 \
        python /data/linxi/workspace/detr/standard_obj_detect.py \
        --th 0.95 \
        --type ${TYPE}
    fi
# /data/linxi/workspace/POPE/llava_qa/question/scene_mmc3_grey_th0.95.json
    # if not exist "/data/linxi/workspace/POPE/llava_qa/question/${TYPE}_mmc3_grey_th0.95.json"; then
    if  [ -f "/data/linxi/workspace/POPE/llava_qa/question/${TYPE}_mmc3_grey_th0.95.json" ]; then
        echo "Running QA_generation on ${TYPE}"
        python /data/linxi/workspace/POPE/QA_generation.py \
        --qa_dir /data/linxi/workspace/ScienceQA/data/scienceqa/ \
        --th 0.95 \
        --file_name ${TYPE}
    fi
done
