#!/bin/bash
model=llava

# TYPE=gqa
# QUESTION_FILE_ls=("gqa_ad_mmc3_grey_th0.5.json" "gqa_ra_mmc3_grey_th0.5.json" "gqa_po_mmc3_grey_th0.5.json")
# IMAGE_FOLDER=$IMAGE_FOLDER

TYPE=grey
QUESTION_FILE_ls=("pope_ra_mmc3_grey.json")
IMAGE_FOLDER=./POPE/data/val/val2014
DATE=0319
SEED_lst=(242)
cfg_values=(0.7)

# if model == llava
if [ "$model" == "llava" ]; then
    echo "Running LLaVA on $QUESTION_FILE with cfg = $cfg, seed = $SEED, batch_size = $BATCH_SIZE"
    export PYTHONPATH=$PYTHONPATH:/path/to/directory/of/LLaVA
    conda activate llava
    cd ./LLaVA
    MODEL_VERSION=llava-llama-2-7b-chat-lightning-preview
    BATCH_SIZE=16
    CUDA_DEVICE=7

elif [ "$model" == "owl" ]; then
    export PYTHONPATH=$PYTHONPATH:/path/to/directory/of/mPLUG-Owl
    conda activate mplug_owl2
    cd ./mPLUG-Owl
    BATCH_SIZE=32
    CUDA_DEVICE=1


elif [ "$model" == "instructblip" ]; then
    export PYTHONPATH=$PYTHONPATH:/path/to/directory/of/LAVIS
    conda activate llava
    cd ./LAVIS
    BATCH_SIZE=16
    CUDA_DEVICE=2

elif [ "$model" == "llava2" ]; then
    export PYTHONPATH=$PYTHONPATH:/path/to/directory/of/LLaVA2
    conda activate llava2
    cd ./LLaVA2/LLaVA
    MODEL_VERSION=llava-v1.5-7b
    BATCH_SIZE=4
    CUDA_DEVICE=4

elif [ "$model" == "minigptv" ]; then
    export PYTHONPATH=$PYTHONPATH:/path/to/directory/of/MiniGPT-4
    conda activate minigptv
    cd ./MiniGPT-4
    BATCH_SIZE=16
    CUDA_DEVICE=5
fi


for QUESTION_FILE in "${QUESTION_FILE_ls[@]}"
do
for SEED in "${SEED_lst[@]}"
do
    for cfg in "${cfg_values[@]}"
    do
    if [ "$model" == "llava" ]; then
        ANSWER_DIR=./LLaVA/answers/apr_${TYPE}_${DATE}/answer_${DATE}_${SEED}
        
        echo "Running LLaVA on $QUESTION_FILE with cfg = $cfg, seed = $SEED, batch_size = $BATCH_SIZE"
        
        CUDA_VISIBLE_DEVICES=$CUDA_DEVICE python -m llava.eval.llava_vqa_cfg \
        --question_file $QUESTION_FILE \
        --cfg $cfg \
        --model_path ./checkpoints/$MODEL_VERSION \
        --answer_path $ANSWER_DIR \
        --seed $SEED \
        --batch_size $BATCH_SIZE \
        --image_folder $IMAGE_FOLDER

    elif [ "$model" == "owl" ]; then
        ANSWER_DIR=./mPLUG-Owl/mPLUG-Owl2/answers/ab_${TYPE}_${DATE}/answer_${DATE}_${SEED}
        echo "Running mPLUG-Owl2-llama2-7b inference with cfg = $cfg, seed = $SEED, batch_size = $BATCH_SIZE"
        CUDA_VISIBLE_DEVICES=$CUDA_DEVICE \
        python ./mPLUG-Owl/mPLUG-Owl2/eval_pope_owl2.py \
        --question_file $QUESTION_FILE \
        --cfg $cfg \
        --answer_path $ANSWER_DIR \
        --seed $SEED  \
        --batch_size $BATCH_SIZE \
        --image_folder $IMAGE_FOLDER

    elif [ "$model" == "instructblip" ]; then
        ANSWER_DIR=./LAVIS/answers/ab_${TYPE}_${DATE}/answer_${DATE}_${SEED}
        echo "Running instructblip-vicuna-7b inference with cfg = $cfg, seed = $SEED, batch_size = $BATCH_SIZE"
        
        CUDA_VISIBLE_DEVICES=$CUDA_DEVICE \
        python ./LAVIS/eval_instructblip_pope.py \
        --model_name_or_path ./LAVIS/instructblip-vicuna-7b \
        --question_file $QUESTION_FILE \
        --cfg $cfg \
        --answer_path $ANSWER_DIR \
        --seed $SEED  \
        --batch_size $BATCH_SIZE \
        --image_folder $IMAGE_FOLDER/
    elif [ "$model" == "llava2" ]; then
        ANSWER_DIR=./LLaVA2/answers/ab_${TYPE}_${DATE}/answer_${DATE}_${SEED}
        echo "Running $MODEL_VERSION inference with cfg = $cfg, seed = $SEED, batch_size = $BATCH_SIZE"
        CUDA_VISIBLE_DEVICES=$CUDA_DEVICE python ./LLaVA2/LLaVA/llava/eval/model_vqa_llava2.py \
        --question_file $QUESTION_FILE \
        --cfg $cfg \
        --model_path ./checkpoints/$MODEL_VERSION \
        --answer_path $ANSWER_DIR \
        --seed $SEED \
        --batch_size $BATCH_SIZE \
        --image_folder $IMAGE_FOLDER

    elif [ "$model" == "minigptv" ]; then
        ANSWER_DIR=./MiniGPT-4/answers/ab_${TYPE}_${DATE}/answer_${DATE}_${SEED}

        echo "Running Minigptv inference with cfg = $cfg"

        CUDA_VISIBLE_DEVICES=$CUDA_DEVICE \
        python ./eval_scripts/eval_vqa_pope.py \
        --cfg-path ./eval_configs/minigptv2_eval.yaml \
        --question_file $QUESTION_FILE \
        --cfg $cfg \
        --answer_path $ANSWER_DIR \
        --seed $SEED \
        --batch_size $BATCH_SIZE \
        --image_folder $IMAGE_FOLDER
    fi
    done
done
done
