#!/bin/bash
# This script is used to run LLaVA on a question file with given cfg value and given seed
# check the following variables before running this script

# SAMPLE: whether to sample or not

CUDA_DEVICE=2
DATE=0126
BATCH_SIZE=3
TYPE="black"
QUESTION_FILE="I4_test_c4.json"
MODEL_VERSION=llava-llama-2-7b-chat-lightning-preview

# SEED=42
# cfg=0.0

SEED_lst=(42 142 242)
cfg_values=(0.5) # sampling

for SEED in "${SEED_lst[@]}"
do
    for cfg in "${cfg_values[@]}"
    do
        ANSWER_DIR=./LLaVA/answers/apope_${TYPE}_${DATE}/answer_${DATE}_${SEED}
        
        echo "Running LLaVA on $QUESTION_FILE with cfg = $cfg, seed = $SEED, batch_size = $BATCH_SIZE"
        
        CUDA_VISIBLE_DEVICES=$CUDA_DEVICE python -m llava.eval.llava_vqa_cfg \
        --question_file $QUESTION_FILE \
        --cfg $cfg \
        --model_path ./checkpoints/$MODEL_VERSION \
        --answer_path $ANSWER_DIR \
        --seed $SEED \
        --batch_size $BATCH_SIZE \
        --sampling
    done
done
