#### SETTING ####
MODEL_VERSION="llava"
DATE=0128
TYPE_ls=("black")
SEED_lst=(17 117 217)
RESULT_FILE="chair_eval"

#### CHAIR EVALUATION ####
for TYPE in "${TYPE_ls[@]}"
do
EVAL_ROOT_DIR="/data/linxi/workspace/LLaVA/answers/answer_${TYPE}_${DATE}"
    for SEED in "${SEED_lst[@]}"
    do
        
        echo "Running $MODEL_VERSION CHAIR metrics with cfg = $cfg, seed = $SEED, batch_size = $BATCH_SIZE"
        EVAL_DIR0="${EVAL_ROOT_DIR}/answer_${DATE}_${SEED}"
        echo $EVAL_DIR0

        python /data/linxi/workspace/POPE/chair/format.py \
        --answer_dir $EVAL_DIR0 \

        python /data/linxi/workspace/CHAIR-metric-standalone/chair.py \
        --save_dir $EVAL_DIR0/$RESULT_FILE \
        --eval_dir $EVAL_DIR0 \
        --model $MODEL_VERSION
    done

    SEED=${SEED_lst[0]}
    EVAL_DIR0="${EVAL_ROOT_DIR}"

    python /data/linxi/workspace/POPE/chair/draw_plot.py \
    --save_dir $EVAL_DIR0 \
    --result_file $RESULT_FILE/eval.json \
    --duplicate
done
