#### FILE PATH ####
DATE=0113
TYPE_ls=("grey")
SEED_lst=(070 090)
MODEL_VERSION="llava"


#### POPE EVALUATION ####
for TYPE in "${TYPE_ls[@]}"
do
    EVAL_ROOT_DIR="/data/linxi/workspace/LLaVA/answers/apope_${TYPE}_${DATE}"
for SEED in "${SEED_lst[@]}"
do
    echo "Running $MODEL_VERSION pope evaluation with seed = $SEED, batch_size = $BATCH_SIZE"

    EVAL_DIR0="${EVAL_ROOT_DIR}/answer_${DATE}_${SEED}"
    echo $EVAL_DIR0

    python /data/linxi/workspace/POPE/chair/format.py \
    --answer_dir $EVAL_DIR0 \

    python /data/linxi/workspace/POPE/POPE_evaluate.py \
    --question_dir /data/linxi/workspace/POPE/llava_pope/question \
    --label_dir /data/linxi/workspace/POPE/llava_pope/label \
    --label_file $QUESTION_FILE \
    --question_file $QUESTION_FILE \
    --answer_dir $EVAL_DIR0 \
    --eval_dir $EVAL_DIR0 \
    --answer_file "" \
    --save_dir $EVAL_DIR0/eval \
    --model $MODEL_VERSION
    done

    SEED=${SEED_lst[0]}
    EVAL_DIR0="${EVAL_ROOT_DIR}"

    python /data/linxi/workspace/POPE/chair/draw_plot.py \
    --save_dir $EVAL_DIR0 \
    --result_file eval/pope_eval.json \
    --metrics "POPE" \
    --duplicate
done
