#!/bin/bash

# Uncomment and set the following variables correspondingly to run this script:

# MODEL_VERSION=vicuna-v1-3-7b
# MODEL_VERSION=llama-2-7b-chat

########### DO NOT CHANGE ###########
########### USE THIS FOR BOTH ###########
PROMPT_VERSION="llava_llama_2"
MODEL_VERSION="llava-llama-2-7b-chat-lightning-preview"
MODEL_NAME="llava-llama-2-7b-chat"
NUM_TRAIN_EPOCHS=0.01
########### DO NOT CHANGE ###########

deepspeed --include localhost:3 llava/backbone/detr_branch/inference_cfg.py \
    --deepspeed ./scripts/zero2.json \
    --model_name_or_path ./checkpoints/$MODEL_VERSION \
    --version $PROMPT_VERSION \
    --vm_vision_tower "detr-v2" \
    --tune_mm_mlp_adapter True \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --bf16 True \
    --output_dir ./llava/backbone/detr_branch/checkpoints_pretrain/$MODEL_NAME-DETR-pretrain-$NUM_TRAIN_EPOCHS \
    --num_train_epochs $NUM_TRAIN_EPOCHS \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 2 \
    --evaluation_strategy "no" \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to wandb\
    --vm_pretrain_mm_mlp_adapter "./llava/backbone/checkpoints_tune/llava-llama-2-7b-chat-DETR-v2-pretrain-1-tune-1/mm_projector.bin" \
    --vision_tower "openai/clip-vit-large-patch14" \
    --pretrain_mm_mlp_adapter "./checkpoints/llava-llama-2-7b-chat-lightning-preview/mm_projector_7b_chat.bin" \
    --vm_mm_vision_select_layer -2 \
    --vm_mm_use_im_start_end False \
    --vm_mm_use_im_patch_token False \
    --vm_tune_mm_mlp_adapter True \


# 21h for 1 gpu
# 5h for 4 gpus
# --vision_tower "facebook/detr-resnet-50" \
# --vision_tower "detr-v2" \
# --vision_tower "clip-detr" \
# vm_pretrain_mm_mlp_adapter: Optional[str] = field(default=None)
# if pretrain_mm_mlp_adapter is not None, then load the pretrain_mm_mlp_adapter from this path
# in most cases, tune_mm_mlp_adapter is set to True when you want to only tune mm layer while keep others frozen
