#!/bin/bash

PROMPT_VERSION="llava_llama_2"
MODEL_VERSION="llava-llama-2-7b-chat-lightning-preview"
PRETRAIN_VERSION="llava-llama-2-7b-chat-DETR-v2-pad-sl1-th07-pretrain-1"

deepspeed --include localhost:6,7 llava/backbone/inference_mm.py \
    --deepspeed ./scripts/zero2.json \
    --model_name_or_path ./checkpoints/$MODEL_VERSION \
    --version $PROMPT_VERSION \
    --vision_tower "detr-v2" \
    --tune_mm_mlp_adapter True \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --bf16 True \
    --per_device_eval_batch_size 32 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "epoch" \
    --logging_steps 100 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 2 \
    --lazy_preprocess True \
    --report_to wandb \
    --eval_image_folder "../POPE/data/minival2014/minival2014" \
    --question_path "../POPE/llava_qa/question" \
    --question_file "I3_sub240_control.json" \
    --answer_path "../POPE/llava_performance/answer" \
    --answer_prompter False \
    --cfg_mode "text" \
    --cfg 0.3 \
    --num_chunks 1 \
    --chunk_id 0 \
    --pretrain_mm_mlp_adapter "./llava/backbone/checkpoints_tune/llava-llama-2-7b-chat-DETR-v2-pretrain-1-tune-1/mm_projector.bin" \
    --output_dir "../POPE/llava_performance/answer" \
    # --tune_manual_mm_projector_path "./llava/backbone/checkpoints_tune/llava-llama-2-7b-chat-DETR-pretrain-1000-tune-1/mm_projector.bin" \


    # --tune_manual_mm_projector_path "./llava/auto_vision_prompt/checkpoints/mm_projector_7b_chat_lightning_preview_15.bin"
    # # --question_file "pope_sub240_control.json" \
    #     --model_path ./checkpoints/llava-llama-2-7b-chat-finetune_lora \
    # --model_base ../llama/Llama-2-7b-chat-hf  \

