#!/bin/bash

#### Model ####
MODEL_SIZE=7b
MODEL_VERSION=llava-llama-2-7b-chat
BASE_BRANCH=lightning-preview
CFG_BRANCH=DETR-v2-pad

#### Prompt ####
PROMPT_VERSION=plain # TODO: do not use llava_llama_2 during pretraining

#### Training ####
NUM_TRAIN_EPOCHS=1

########## Run ##########
deepspeed --include localhost:4,5 llava/backbone/tune_mm_cfg.py \
    --deepspeed ./scripts/zero2.json \
    --model_name_or_path ./checkpoints/$MODEL_VERSION-$BASE_BRANCH \
    --version $PROMPT_VERSION \
    --data_path ./data/pretrain/LLaVA-CC3M-Pretrain-595K/chat.json \
    --image_folder ./data/pretrain/LLaVA-CC3M-Pretrain-595K/images \
    --bf16 True \
    --output_dir ./llava/backbone/detr_branch/checkpoints_pretrain_cfg/$MODEL_VERSION-$BASE_BRANCH-$CFG_BRANCH-pretrain_cfg-$NUM_TRAIN_EPOCHS \
    --num_train_epochs $NUM_TRAIN_EPOCHS \
    --per_device_train_batch_size 32 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 2 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 2000 \
    --save_total_limit 1 \
    --learning_rate 2e-3 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 20 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to wandb \
    --vision_tower "openai/clip-vit-large-patch14" \
    --pretrain_mm_mlp_adapter "./checkpoints/llava-llama-2-7b-chat-lightning-preview/mm_projector_7b_chat.bin" \
    --tune_mm_mlp_adapter True \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --vm_vision_tower "detr-v2" \
    --vm_pretrain_mm_mlp_adapter ./llava/backbone/checkpoints_tune/$MODEL_VERSION-$CFG_BRANCH/mm_projector.bin \
    --vm_mm_vision_select_layer -2 \
    --vm_tune_mm_mlp_adapter True \
    --vm_mm_use_im_start_end False \
    --vm_mm_use_im_patch_token False \