#!/bin/bash

# deepspeed --include localhost:3,4,5 llava/eval/model_vqa_vision_prompt.py \
#     --deepspeed ./scripts/zero3.json \
PROMPT_VERSION="llava_llama_2"
MODEL_VERSION="llava-llama-2-7b-chat-lightning-preview"
NUM_TRAIN_EPOCHS=1

CUDA_VISIBLE_DEVICES=4,5 python llava/eval/model_vqa_vision_prompt.py \
    --model_name_or_path ./checkpoints/$MODEL_VERSION \
    --version $PROMPT_VERSION \
    --data_path ./data/labels_train2017.json \
    --image_folder ./data/train2017 \
    --vision_tower openai/clip-vit-large-patch14 \
    --tune_mm_mlp_adapter True \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --bf16 True \
    --output_dir ./llava/auto_vision_prompt/checkpoints/llava-$MODEL_VERSION-$NUM_TRAIN_EPOCHS \
    --num_train_epochs $NUM_TRAIN_EPOCHS \
    --per_device_train_batch_size 64 \
    --per_device_eval_batch_size 32 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "epoch" \
    --save_strategy "epoch" \
    --save_total_limit 4 \
    --load_best_model_at_end True \
    --metric_for_best_model "loss" \
    --greater_is_better False \
    --learning_rate 0.0002 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --logging_steps 100 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 2 \
    --lazy_preprocess True \
    --report_to wandb \ 
    # --model_path "./checkpoints/llava-llama-2-7b-chat-lightning-preview" \
    # --model-base None \
    # --eval_image_folder "../POPE/data/minival2014/minival2014" \
    # --question_path "../POPE/llava_qa/question" \
    # --answer_path "../POPE/llava_qa/answer" \
    # --question_file "I3_sub240_control.json" \
    # --answers_file None \
    # --conv-mode "llava_v0" \
    # --cfg_mode "image" \
    # --num-chunks 1 \
    # --chunk-idx 0 \
    # --cfg 0.3 \


