#!/bin/bash

# Uncomment and set the following variables correspondingly to run this script:

# MODEL_VERSION=vicuna-v1-3-7b
# MODEL_VERSION=llama-2-7b-chat

########### DO NOT CHANGE ###########
########### USE THIS FOR BOTH ###########
PROMPT_VERSION="llava_llama_2"
MODEL_VERSION="llava-llama-2-7b-chat-lightning-preview"
########### DO NOT CHANGE ###########

deepspeed --include localhost:2,1 llava/auto_vision_prompt/train_obj_detector.py \
    --deepspeed ./scripts/zero3.json \
    --model_name_or_path ./checkpoints/$MODEL_VERSION \
    --version $PROMPT_VERSION \
    --data_path ./data/labels_train2017.json \
    --image_folder ./data/train2017 \
    --vision_tower openai/clip-vit-large-patch14 \
    --tune_mm_mlp_adapter True \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --bf16 True \
    --output_dir ./checkpoints/llava-$MODEL_VERSION-13 \
    --num_train_epochs 13 \
    --per_device_train_batch_size 64 \
    --per_device_eval_batch_size 32 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "epoch" \
    --save_strategy "epoch" \
    --save_total_limit 1 \
    --learning_rate 0.0002 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --logging_steps 100 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 2 \
    --lazy_preprocess True \
    --report_to wandb \ 
    # --freeze_backbone True \
    # --save_steps 50 \
# add --freeze_backbone True \
# CUDA_VISIBLE_DEVICES=2,4 python llava/auto_vision_prompt/train_obj_detector.py \

