from matplotlib import pyplot as plt
import json
import os
import seaborn as sns
import pandas as pd
import glob
import argparse
from draw_plot import load_eval_results,load_group_eval_results

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--duplicate", action='store_true')
    parser.add_argument("--save_dir", type=str,
                        default='../POPE/chair')
    parser.add_argument("--result_file_name", type=str, default='eval/eval.json')
    parser.add_argument("--metrics", type=str, default='CHAIR')
    parser.add_argument("--yaml_file", type=str, default='config.yaml')
    args = parser.parse_args()

    os.makedirs(args.save_dir, exist_ok=True)
    load_group_eval_results(args.save_dir, args.result_file_name, args.metrics, args.yaml_file)