From Hammer Require Import Hammer.
(* start imports *)
Require Import QArith.
Require Import QArith_base.
Open Scope Q_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: Q -> Q -> Q -> Q) (a b c: Q) : Prop :="
  docstring: |
    Given the lengths of the three sides of a triangle. Implementation impl must return the area
    of the triangle rounded to 2 decimal points if the three sides form a valid triangle.
    Otherwise implementation impl must return -1.
    Three sides make a valid triangle when the sum of any two sides is greater than the third side.
  test_cases:
    - input: (3, 4, 5)
      expected_output: 6
    - input: (1, 2, 10)
      expected_output: -1
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: Q -> Q -> Q -> Q) (a b c: Q) : Prop :=
  let is_valid_triangle : Prop := (a + b > c) /\ (a + c > b) /\ (b + c > a) in
  let s := (a + b + c) / 2 in
  let eps := Qmake 1 10000%positive in
  exists r,
    impl a b c = r /\
    let diff := r * r - (s * (s - a) * (s - b) * (s - c)) in
    (is_valid_triangle -> (-(eps) <= diff /\ diff <= eps)) /\
    (~ is_valid_triangle -> r = Qmake (-1)%Z 1%positive).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: Q -> Q -> Q -> Q) (a b c: Q) : Prop :=
  let is_valid_triangle : Prop := (a + b > c) /\ (a + c > b) /\ (b + c > a) in
  let s := (a + b + c) / 2 in
  let eps := Qmake 1 10000%positive in
  exists r,
    impl a b c = r /\
    let diff := r * r - (s * (s - a) * (s - b) * (s - c)) in
    (is_valid_triangle -> (-(eps) <= diff /\ diff <= eps)) /\
    (~ is_valid_triangle -> r = Qmake (-1)%Z 1%positive).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall a b c, problem_spec impl a b c) <->
               (forall a b c, generated_spec impl a b c).
Proof. hammer. Qed.
(* end equivalence *)
