From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import Nat.
Import ListNotations.

Open Scope nat_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: nat -> list nat) (n: nat) : Prop :="
  docstring: |
    Implementation impl must implement the following function. Assume all inputs are valid:
    Given a positive integer n, you have to make a pile of n levels of stones.
    The first level has n stones.
    The number of stones in the next level is:
      - the next odd number if n is odd.
      - the next even number if n is even.
    Return the number of stones in each level in a list, where element at index
    i represents the number of stones in the level (i+1).
  test_cases:
    - input: 3
      expected_output: [3, 5, 7]
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: nat -> list nat) (n: nat) : Prop :=
  exists res, impl n = res /\
    length res = n /\
    nth 0 res 0 = n /\
    forall i : nat, (1 <= i /\ i < n) -> nth i res 0 = nth (i - 1) res 0 + 2.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> list nat) (n: nat) : Prop :=
  exists res, impl n = res /\
    length res = n /\
    nth 0 res 0 = n /\
    forall i : nat, (1 <= i /\ i < n) -> nth i res 0 = nth (i - 1) res 0 + 2.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall n, problem_spec impl n) <->
               (forall n, generated_spec impl n).
Proof. hammer. Qed.
(* end equivalence *)
