From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import Nat.
Import ListNotations.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: list nat -> bool) (arr: list nat) : Prop :="
  docstring: |
    Implementation impl must implement the following function:

    We have an array 'arr' of N integers arr[1], arr[2], ..., arr[N].The
    numbers in the array will be randomly ordered. Your task is to determine if
    it is possible to get an array sorted in non-decreasing order by performing
    the following operation on the given array:
        You are allowed to perform right shift operation any number of times.

    One right shift operation means shifting all elements of the array by one
    position in the right direction. The last element of the array will be moved to
    the starting position in the array i.e. 0th index.

    If it is possible to obtain the sorted array by performing the above operation
    then return True else return False.
    If the given array is empty then return True.

    Note: The given list is guaranteed to have unique elements. Assume eveerything is a natural number.
  test_cases:
    - input: [3, 4, 5, 1, 2]
      expected_output: true
    - input: [3, 5, 4, 1, 2]
      expected_output: false
*)
(* end prompt *)

(* start context *)
Parameter is_shifted_forall :
  forall (xs ys : list nat) (i : nat), Prop.

Parameter is_sorted :
  forall (xs : list nat), Prop.
(* end context *)

(* start problem_spec *)

Definition problem_spec (impl: list nat -> bool) (arr: list nat) : Prop :=
  exists r, impl arr = r /\
    ((arr = []) -> r = true) /\
    (r = true <->
       exists i arr_shifted,
         length arr = length arr_shifted /\
         i < length arr /\
         is_shifted_forall arr arr_shifted i /\
         is_sorted arr_shifted).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: list nat -> bool) (arr: list nat) : Prop :=
  exists r, impl arr = r /\
    ((arr = []) -> r = true) /\
    (r = true <->
       exists i arr_shifted,
         length arr = length arr_shifted /\
         i < length arr /\
         is_shifted_forall arr arr_shifted i /\
         is_sorted arr_shifted).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall arr, problem_spec impl arr) <->
               (forall arr, generated_spec impl arr).
Proof. hammer. Qed.
(* end equivalence *)
