From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import ZArith.
Import ListNotations.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(* 
  function_signature: "Definition generated_spec (impl: nat -> nat) (x: nat) : Prop :="
  docstring: |
    Imagine a road that's a perfectly straight infinitely long line.
    n cars are driving left to right;  simultaneously, a different set of n cars
    are driving right to left.   The two sets of cars start out being very far from
    each other.  All cars move in the same speed.  Two cars are said to collide
    when a car that's moving left to right hits a car that's moving right to left.
    However, the cars are infinitely sturdy and strong; as a result, they continue moving
    in their trajectory as if they did not collide.
    The function impl outputs the number of such collisions.
  test_cases:
    - input: 0
        expected_output: 0
    - input: 5
        expected_output: 25
*)
(* end prompt *)


(* start problem_spec *)
Definition problem_spec (impl: nat -> nat) (x: nat) : Prop :=
    exists r, impl x = r /\ r = x * x.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> nat) (x: nat) : Prop :=
    exists r, impl x = r /\ r = x * x.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall x, problem_spec impl x) <->
               (forall x, generated_spec impl x).
Proof. hammer. Qed.
(* end equivalence *)
