From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import Nat.
Import ListNotations.
Open Scope nat_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: nat -> nat -> nat -> list nat) (number need remaining: nat) : Prop :="
  docstring: |
    Implementation impl solves the following problem:
    
    You're a hungry rabbit, and you already have eaten a certain number of carrots,
    but now you need to eat more carrots to complete the day's meals.
    you should return an array of [ total number of eaten carrots after your meals,
                                    the number of carrots left after your meals ]
    if there are not enough remaining carrots, you will eat all remaining carrots, but will still be hungry.

    Variables:
      @number : integer
          the number of carrots that you have eaten.
      @need : integer
          the number of carrots that you need to eat.
      @remaining : integer
          the number of remaining carrots thet exist in stock

    Constraints:
    * 0 <= number <= 1000
    * 0 <= need <= 1000
    * 0 <= remaining <= 1000
  test_cases:
    - input: [5, 6, 10]
      expected_output: [11, 4]
    - input: [4, 8, 9]
      expected_output: [12, 1]
    - input: [1, 10, 10]
      expected_output: [11, 0]
    - input: [2, 11, 5]
      expected_output: [7, 0]
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: nat -> nat -> nat -> list nat)
                        (number need remaining: nat) : Prop :=
  exists res, impl number need remaining = res /\
    (number <= 1000 -> need <= 1000 -> remaining <= 1000 ->
      length res = 2 /\
      (need <= remaining -> nth 0 res 0 = number + need /\
        nth 1 res 0 = remaining - need) /\
      (remaining < need -> nth 0 res 0 = number + remaining /\ nth 1 res 0 = 0)).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> nat -> nat -> list nat)
                          (number need remaining: nat) : Prop :=
  exists res, impl number need remaining = res /\
    (number <= 1000 -> need <= 1000 -> remaining <= 1000 ->
      length res = 2 /\
      (need <= remaining -> nth 0 res 0 = number + need /\
        nth 1 res 0 = remaining - need) /\
      (remaining < need -> nth 0 res 0 = number + remaining /\ nth 1 res 0 = 0)).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl,
    (forall number need remaining, problem_spec impl number need remaining) <->
    (forall number need remaining, generated_spec impl number need remaining).
Proof. hammer. Qed.
(* end equivalence *)
