From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import QArith.
Import ListNotations.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(* 
  function_signature: "Definition generated_spec (impl: Q -> Q -> Q) (a h: Q) : Prop :="
    docstring: |
        Given length of a side and high implementation impl returns area for a triangle.
    test_cases:
    - input: (5, 3)
        expected_output: 7.5
    - input: (8, 2)
        expected_output: 8.0
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: Q -> Q -> Q) (a h: Q) : Prop :=
    exists r, impl a h = r /\ r = (a * h) / 2.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: Q -> Q -> Q) (a h: Q) : Prop :=
    exists r, impl a h = r /\ r = (a * h) / 2.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall a h, problem_spec impl a h) <->
               (forall a h, generated_spec impl a h).
Proof. hammer. Qed.
(* end equivalence *)
